/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8281.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8281.DeviceView.BuilderLike;
import ibm.nways.jdm8281.DeviceView.ChassisLike;
import ibm.nways.jdm8281.DeviceView.ConnectorLike;
import ibm.nways.jdm8281.DeviceView.Factory;
import ibm.nways.jdm8281.DeviceView.FactoryLike;
import ibm.nways.jdm8281.DeviceView.OptionalCardLike;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.rmi.RemoteException;

public class Builder
implements BuilderLike {
    static final BuilderLike instance = new Builder();
    private static final int RASID = 19;
    private static final int RASSUB = 12;
    private static FactoryLike factory = Factory.getInstance();

    private Builder() {
    }

    public static BuilderLike getInstance() {
        return instance;
    }

    public ChassisLike buildChassis(JdmBrowser jdmBrowser) {
        Object object;
        GenModel genModel = (GenModel)jdmBrowser.getModel();
        Serializable serializable = null;
        try {
            object = (GenModel)genModel.getComponent("System");
            ModelInfo modelInfo = object.getInfo("Panel");
            serializable = modelInfo.get("Panel.SysObjectID");
            if (RAS.isEnabled(19, 12)) {
                RAS.trace(19, 12, this, "ChassisLike", "Sysoid = " + serializable);
            }
        }
        catch (RemoteException remoteException) {
            RAS.logException(19, 12, this, "buildChassis", (Exception)remoteException);
        }
        object = Factory.getInstance().createChassis(serializable);
        object.setCommonInformation(jdmBrowser);
        object.discoverChildren();
        return object;
    }

    public ConnectorLike buildResetButton(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createResetButton();
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildResetButtonInv(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createResetButtonInv();
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildTty(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createTty();
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildTtyInv(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createTtyInv();
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildPort(int n, JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createPort(n);
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildPortInv(int n, JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createPortInv(n);
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildAuiPort(int n, JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createAuiPort(n);
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildAuiPortInv(int n, JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        ConnectorLike connectorLike = factory.createAuiPortInv(n);
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public ConnectorLike buildAtm(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        if (RAS.isEnabled(19, 12)) {
            RAS.trace(19, 12, this, "ConnectorLike", "### Building an Atm Connector for StandAlone");
        }
        ConnectorLike connectorLike = factory.createAtm();
        connectorLike.setCommonInformation(jdmBrowser, graphicContainer);
        return connectorLike;
    }

    public OptionalCardLike buildOptionalPortCard(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        OptionalCardLike optionalCardLike = factory.createOptionalPortCard();
        optionalCardLike.setCommonInformation(jdmBrowser, graphicContainer);
        optionalCardLike.discoverChildren();
        return optionalCardLike;
    }

    public OptionalCardLike buildOptionalAtmCard(JdmBrowser jdmBrowser, GraphicContainer graphicContainer) {
        OptionalCardLike optionalCardLike = factory.createOptionalAtmCard();
        optionalCardLike.setCommonInformation(jdmBrowser, graphicContainer);
        optionalCardLike.discoverChildren();
        return optionalCardLike;
    }
}

